
#ifndef _1_CRYS_SEP_ATP_RC4_Acceptance_h_H
#define _1_CRYS_SEP_ATP_RC4_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_RC4_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RC4_NotIntegrated         
* 
* Inputs:
* OperationMode - The operation mode : MD5 or SHA1.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 non integrated API's                         
*  This function Encrypts and Decrypts known vectors using RC4 
*  Vector sizes used (in bytes) - 16/32/45/512/1536
*  Key Size used (in bytes)    - 16/32/45/256
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
* 1. Call the CRYS_RC4_Init function to start the encryption/decryption process
* 2. Call the CRYS_RC4_Stream - This function is called N times
*                              (N = number of blocks in data each block is 1byte)
* 3. Call the CRYS_RC4_Free to end the encryption/decryption process 
* 4. Compare the outputted result to the expected one 
*
**************************************************************************************/                                
CRYSError_t SEPQA_RC4_NotIntegrated(
		DxUint8_t 		*KeyPtr,
		DxUint16_t		KeySize,
		DxUint8_t       EncryptDecryptFlag,
		DxUint8_t       OutputLocation,
		DxUint8_t       *DataIn_ptr,
		DxUint32_t      DataInSize,
		DxUint8_t       *ExpectedData_ptr,        
		DxUint32_t      DataExpSize,
		DxUint8_t       *FailureFunctionNameOut_ptr);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RC4_Integrated         
* 
* Inputs:
* Key_ptr -  A pointer to the user's key buffer.
* KeySize - The size of the KEY in bytes.
* EncryptDecryptFlag - flag to execute encrypt/decrypt
* OutputLocation - indication if input buffer == output buffer or not.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 non integrated API's                         
*  This function Encrypts and Decrypts known vectors using RC4 
*  Vector sizes used (in bytes) - 512
*  Key Size used (in bytes)    - 256
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
* 1. Allocate memory buffers
* 2. Call the CRYS_RC4_to Preform the encryption/decryption process
* 3. Compare the outputted result to the expected one                                                   
* 6. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RC4_Integrated(	DxUint8_t 		*KeyPtr,
								 DxUint16_t		KeySize,
								 DxUint8_t       EncryptDecryptFlag,
								 DxUint8_t       OutputLocation,
								 DxUint8_t       *DataIn_ptr,
								 DxUint32_t      DataInSize,
								 DxUint8_t       *ExpectedData_ptr,        
								 DxUint32_t      DataExpSize,
								 DxUint8_t       *FailureFunctionNameOut_ptr);





#ifdef __cplusplus
}
#endif

#endif


